//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3

import wesual.Controls 1.0

DialogItem {
    id : dialog

    property bool rejectOnClickOutside : false
    property list<DialogButton> buttons : [
        DialogButton {
            text : qsTrId("c4260415c3a56cd3")
            onClicked : dialog.accept(dialog.result)
        },
        DialogButton {
            text : qsTrId("37ae1dd525a0ce7a")
            onClicked : dialog.reject()
        }
    ]
    property int       primaryButtonIndex : 0
    property string    label : ""
    property string    instructionText : ""
    property Component delegate
    property Component headerDelegate : Item { width : 1; height : 13 }
    property int       contentHeight : 600
    property int       contentWidth  : 400
    property Item      contentItem
    property var       result

    QtObject {
        id : p_

        property int buttonActiveFocus : primaryButtonIndex

        onButtonActiveFocusChanged : {
            if (repeater.model) {
                if (buttonActiveFocus >= 0 &&
                    buttonActiveFocus < repeater.model.length)
                    repeater.itemAt(buttonActiveFocus).focus = true;
            }
        }
    }

    Component.onCompleted : {
        if (delegate) {
            dialog.contentItem = delegate.createObject(container);
        }
        if (headerDelegate) {
            headerDelegate.createObject(header);
        }
    }

    onEnabledChanged : {
        if (enabled) {
            // reset repeater Buttons model to get proper states on open
           repeater.model = dialog.buttons;
        }
    }

    anchors.fill : parent ? parent : undefined

    focus : true

    // key handling
    Keys.onLeftPressed : {
        p_.buttonActiveFocus--;

        // wrapping
        if (p_.buttonActiveFocus < 0)
            p_.buttonActiveFocus = repeater.model.length - 1;
    }
    Keys.onRightPressed : {
        p_.buttonActiveFocus++;

        // wrapping
        if (p_.buttonActiveFocus > repeater.model.length - 1)
            p_.buttonActiveFocus = 0;
    }
    Keys.onPressed : {
        if (event.key === Qt.Key_Escape) {
           dialog.reject();
           event.accepted = true;
        } else if(event.key === Qt.Key_Enter || event.key === Qt.Key_Return) {
            dialog.accept(dialog.result);
            event.accepted = true;
        }
    }

    opacity : dialog.open ? 1 : 0

    Behavior on opacity {
        NumberAnimation {
            duration : 200
        }
    }

    Rectangle {
        id : cover
        color : "#11000000"
        anchors.fill : parent

        MouseArea {
            anchors.fill : parent
            acceptedButtons : Qt.LeftButton | Qt.RightButton
            hoverEnabled : true
            onWheel : {
                // catch wheel
            }
            onClicked : {
                if (rejectOnClickOutside) {
                    dialog.reject();
                }
            }
        }
    }

    BorderImage {
        id : shadow
        // 9-slice-margins : 18px
        // shadow offset : 13px
        // add 2*offset + 2*(margins-(margins-offset)) to width
        width : content.width + 26 + 32
        height : content.height + 26 + 32
        anchors.centerIn : parent
        border {
            left : 18 + 13
            top : 18 + 13
            right : 18 + 13
            bottom : 18 + 13
        }
        horizontalTileMode : BorderImage.Stretch
        verticalTileMode : BorderImage.Stretch
        source : "qrc:/controls/images/dialog-shadow.png"
    }

    Rectangle {
        id : content

        anchors.centerIn : parent
        width : contentWidth
        height : contentHeight

        Behavior on opacity {
            NumberAnimation {
                duration : 200
            }
        }

        MouseArea {
            anchors.fill    : parent
            acceptedButtons : Qt.LeftButton | Qt.RightButton
            z : -1
            onClicked : container.focus = true
        }

        Rectangle {
            color : UI.color(UI.DialogHeader)
            anchors {
                top    : parent.top
                left   : parent.left
                right  : parent.right
                bottom : header.bottom
            }
        }

        Column {
            id : header

            anchors {
                top       : parent.top
                topMargin : 13
                left      : parent.left
                right     : parent.right
                margins   : 0
            }
            spacing : 2
            height : implicitHeight

            Text {
                font {
                    family : UI.fontFamily(UI.PrimaryFont)
                    weight : UI.fontWeight(UI.PrimaryFont)
                    pixelSize : 18
                }
                color : UI.color(UI.DialogHeaderText)
                x : 15
                text : dialog.label
            }
            Text {
                id : instructionLabel

                font {
                    family : UI.fontFamily(UI.PrimaryFont)
                    weight : UI.fontWeight(UI.PrimaryFont)
                    pixelSize : 13
                }
                color : UI.color(UI.DialogHeaderText)
                x : 15
                text : dialog.instructionText
                visible : dialog.instructionText.length > 0
            }
        }

        Item {
            id : container

            anchors {
                left : parent.left
                right : parent.right
                top : header.bottom
                bottom : buttonBar.top
            }
        }

        Item {
            id : buttonBar

            anchors {
                bottom : parent.bottom
                left : parent.left
                leftMargin : 7
                right : parent.right
                rightMargin : 7
            }
            height : 48

            Rectangle {
                height : 1
                anchors {
                    left : parent.left
                    right : parent.right
                    top : parent.top
                }
                color : UI.color(UI.PrimaryControlBorder)
            }

            Row {
                anchors {
                    right : parent.right
                    rightMargin : 8
                    verticalCenter : parent.verticalCenter
                }
                spacing : 4

                Repeater {
                    id : repeater
                    delegate : PushButton {
                        text : modelData.text
                        enabled : modelData.enabled
                        isPrimary : index === dialog.primaryButtonIndex
                        onClicked : modelData.clicked()
                        visible : modelData.visible
                    }
                }
            }
        }
    } // content
}
